/*
 * Decompiled with CFR 0.152.
 */
package net.unusual.blockfactorysbosses.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.unusual.blockfactorysbosses.client.model.Modelsandworm;
import net.unusual.blockfactorysbosses.entity.SandwormEntity;
import net.unusual.blockfactorysbosses.network.BlockFactorysBossesModVariables;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector3f;

public class SandwormRenderer
extends MobRenderer<SandwormEntity, Modelsandworm<SandwormEntity>> {
    public SandwormRenderer(EntityRendererProvider.Context context) {
        super(context, new Modelsandworm(context.bakeLayer(Modelsandworm.LAYER_LOCATION)), 0.0f);
        this.addLayer(new ItemInHandLayer(this));
    }

    public ResourceLocation getTextureLocation(SandwormEntity entity) {
        return ResourceLocation.parse((String)"block_factorys_bosses:textures/entities/sandworm.png");
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class ItemInHandLayer<T extends LivingEntity, M extends EntityModel<T>>
    extends RenderLayer<T, M> {
        public ItemInHandLayer(RenderLayerParent<T, M> layer) {
            super(layer);
        }

        public void render(@NotNull PoseStack pose, @NotNull MultiBufferSource bufferSource, int packedLight, T entity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
            int attack_animtime = (Integer)entity.getEntityData().get(SandwormEntity.DATA_attack_animtime);
            int attack_phase = (Integer)entity.getEntityData().get(SandwormEntity.DATA_attack_phase);
            if (!Minecraft.getInstance().isPaused() && (Integer)entity.getEntityData().get(SandwormEntity.DATA_spawn_animtime) > 0 && (Integer)entity.getEntityData().get(SandwormEntity.DATA_spawn_animtime) <= 170) {
                pose.pushPose();
                EntityModel entityModel = this.getParentModel();
                if (entityModel instanceof Modelsandworm) {
                    Modelsandworm model = (Modelsandworm)entityModel;
                    model.translateToHead(pose);
                }
                pose.translate(0.0f, 0.0f, 0.0f);
                pose.mulPose(Axis.XP.rotationDegrees(90.0f));
                pose.scale(1.0f, 1.0f, 1.0f);
                Vec3 cameraPos = Minecraft.getInstance().gameRenderer.getMainCamera().getPosition();
                Vector3f translation = new Vector3f();
                pose.last().pose().getTranslation(translation);
                BlockFactorysBossesModVariables.cinematicX = (double)translation.x() + cameraPos.x;
                BlockFactorysBossesModVariables.cinematicY = (double)translation.y() + cameraPos.y;
                BlockFactorysBossesModVariables.cinematicZ = (double)translation.z() + cameraPos.z;
                pose.popPose();
            }
        }
    }
}

